﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.XPath;
using System.Xml;
using System.Xml.Linq;

namespace Chapter_21
{
    class Program
    {
        string m_xmlFileName = "moneytalk.xml";

        static void Main()
        {
            var prog = new Program();

            prog.XmlReaderWriterDemo();

            prog.XPathDocumentDemo();

            prog.XmlDocumentDemo();

            prog.CreateLINQtoXMLDocument();

            prog.CreateLINQtoXMLDocumentWithAttributes();

            prog.CreateLINQtoXMLDocumentWithNamespace();

            prog.ReadXMLDocWithLINQtoXML();

            prog.QueryWithLINQtoXML();

            prog.ModifyDocWithLINQtoXML();

            Console.ReadKey();
        }

        private void ModifyDocWithLINQtoXML()
        {
            var doc = XDocument.Load("moneytalk.xml");

            doc.Element("moneyTalk").Add(
                new XElement("talk",
                    "Zachowaj swoje marne grosze. Być może będą kiedyś coś warte."));

            var talkElements =
                from talk in doc.Element("moneyTalk").Elements()
                where talk.Value.Contains("pieniądze")
                select talk;

            talkElements.Single().Remove();

            talkElements =
                from talk in doc.Element("moneyTalk").Elements()
                where talk.Value.Contains("złotego")
                select talk;

            talkElements.Single().ReplaceWith(
                new XElement("talk",
                    "Zaoszczędzony grosz to za mało, zamień go na złotówkę."));

            doc.Save("moneytalk.xml");

            doc = XDocument.Load("moneytalk.xml");

            Console.WriteLine("Dokument LINQ to XML: \n" + doc.ToString());
        }

        private void QueryWithLINQtoXML()
        {
            var doc = XDocument.Load("moneytalk.xml");

            var talkElements =
                from talk in doc.Element("moneyTalk").Elements()
                where talk.Value.Contains("pieniądze")
                select talk;

            talkElements.ToList().ForEach(
                talkElement => Console.WriteLine(
                    "Składnik węzła talk: {0}", talkElement.Value));
        }

        private void ReadXMLDocWithLINQtoXML()
        {
            var doc = XDocument.Load("moneytalk.xml");

            Console.WriteLine("Dokument LINQ to XML: \n" + doc.ToString());
        }

        private void CreateLINQtoXMLDocumentWithNamespace()
        {
            XNamespace moneyNames = "http://www.helion.pl/CSharp30KsiegaEksperta/XML";

            XDocument doc =
                new XDocument(
                    new XElement(moneyNames + "moneyTalk",
                        new XElement(moneyNames + "talk", "Zaoszczędzony grosz to za mało, zamień go na złotówkę."),
                        new XElement(moneyNames + "talk", "Zachowaj swoje marne grosze. Być może będą kiedyś coś warte.")));

            Console.WriteLine("Dokument LINQ to XML: \n" + doc.ToString());
        }

        private void CreateLINQtoXMLDocumentWithAttributes()
        {
            XDocument doc =
                new XDocument(
                    new XElement("moneyTalk",
                        new XElement("talk",
                            new XAttribute("quote", "Zaoszczędzony grosz to za mało, zamień go na złotówkę.")),
                        new XElement("talk",
                            new XAttribute("quote", "Zachowaj swoje marne grosze. Być może będą kiedyś coś warte."))));

            Console.WriteLine("Dokument LINQ to XML: \n" + doc.ToString());
        }

        private void CreateLINQtoXMLDocument()
        {
            XDocument doc =
                new XDocument(
                    new XElement("moneyTalk",
                        new XElement("talk", "Zaoszczędzony grosz to za mało, zamień go na złotówkę."),
                        new XElement("talk", "Zachowaj swoje marne grosze. Być może będą kiedyś coś warte.")));

            Console.WriteLine("Dokument LINQ to XML: \n" + doc.ToString());
        }
        
        /// <summary>
        /// edycja za pomocą obiektu XmlDocument
        /// </summary>
        private void XmlDocumentDemo()
        {
            var xDoc = new XmlDocument();
            xDoc.Load(m_xmlFileName);

            var xPathNav = xDoc.CreateNavigator();

            xPathNav.MoveToFirstChild();
            xPathNav.MoveToNext();
            xPathNav.AppendChild(
                "<talk>Pieniądze nie są...? Chwileczkę - z jakiej planety pochodzisz?</talk>");

            xPathNav.MoveToFirstChild();
            xPathNav.SetValue(xPathNav.Value.Replace("złotówkę", "złotego"));

            xPathNav.MoveToNext();
            xPathNav.DeleteSelf();

            Console.WriteLine(xDoc.OuterXml);

            xDoc.Save(m_xmlFileName);
        }

        /// <summary>
        /// czytanie za pomocą obiektu XPathDocument
        /// </summary>
        private void XPathDocumentDemo()
        {
            var xPathDoc = new XPathDocument(m_xmlFileName);

            XPathNavigator xPathNav = xPathDoc.CreateNavigator();
            XPathNodeIterator xPathIter = xPathNav.Select("//talk");

            foreach (var node in xPathIter)
            {
                Console.WriteLine("Rozmowa o pieniądzach: {0}", node.ToString());
            }
        }

        /// <summary>
        /// sposób użycia XmlReader i XmlWriter
        /// </summary>
        private void XmlReaderWriterDemo()
        {
            var money = new MoneyTalk
            {
                FileName = m_xmlFileName
            };

            money.WriteXML();
            money.ReadXML();
        }
    }
}
